/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    private static Map<Class, Collection<Class>> classCache = new HashMap<Class, Collection<Class>>();

    private static Set<Class> findClasses(String pckgname, Class clazz) {
        URL url;
        HashSet<Class> output = new HashSet<Class>();
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = Utility.class.getResource(name = name.replace('.', '/'))) == null) {
            return output;
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            for (String filename : directory.list()) {
                char firstLetter = filename.charAt(0);
                if (firstLetter < 'A' || firstLetter > 'Z' && firstLetter < 'a' || firstLetter > 'z' || !filename.endsWith(".class")) continue;
                String classname = filename.substring(0, filename.length() - 6);
                try {
                    String className = pckgname + "." + classname;
                    Class<?> c = Class.forName(className);
                    if (!clazz.isAssignableFrom(c)) continue;
                    output.add(c);
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
            }
        }
        return output;
    }

    public static List<Class> findAllSubclasses(Class clazz) {
        if (classCache.containsKey(clazz)) {
            return (List)classCache.get(clazz);
        }
        TreeMap<String, Class> allClasses = new TreeMap<String, Class>();
        for (Package p : Package.getPackages()) {
            if (p.getName().startsWith("java") || p.getName().startsWith("com.sun") || p.getName().startsWith("com.oracle")) continue;
            for (Class c : Utility.findClasses(p.getName(), clazz)) {
                if (Modifier.isAbstract(c.getModifiers())) continue;
                allClasses.put(c.getSimpleName(), c);
            }
        }
        ArrayList<Class> values = new ArrayList<Class>(allClasses.values());
        classCache.put(clazz, values);
        return values;
    }
}

